/*-------------------------------------------------------*
*  Name:      Export.cpp                                 *
*  Purpose:   XO files Export ode                       *
*  Authors:   Oleg M.                                    *
*  History:   16.Oct.2002 - started                      *
*                                                        *
*-------------------------------------------------------*/
#include <Struct.h>
#include <3DEngine.h>

#include "xo.h"

static bool bLocked = TRUE;

DWORD CALLBACK MultipleExportV8ChallengeXO(CFile* pFile, tObject* pObj, CDirect3D* d3d)
{
  //can we seek for the [D] partner?
  //crop filename a bit...
  char* filename = strdup(pObj->ObjectName);
  int len = strlen(filename);
  if (len > 3)
    if ((filename[len-3] == 'A') ||
        (filename[len-3] == 'a'))
      strcpy(&filename[len-3], &filename[len-2]);
  CString objname = filename;
  CString damPartner = objname+CString("[D]");
  free(filename);
  filename = strdup(pFile->GetFileTitle());
  char* pch = strrchr(filename, '.');
  if (pch)
    *pch = 0;
  len = strlen(filename);
  if (len > 3)
    if ((filename[len-3] == 'A') ||
        (filename[len-3] == 'a'))
      strcpy(&filename[len-3], &filename[len-2]);
  objname = filename;
  free(filename);
  objname = CString("../vertices/")+objname;


  tObject* pDamPartner = NULL;
  long i, obj, mat, face, vert;
  for (obj = 0; obj < CurrentState.CurrentParams.Objects->ObjAmount; obj++)
    if (!strcmp(damPartner, CurrentState.CurrentParams.Objects->ObjSet[obj].ObjectName))
    {
      if ((CurrentState.CurrentParams.Objects->ObjSet[obj].VertTable->VertAmount == 
           pObj->VertTable->VertAmount) &&
          (CurrentState.CurrentParams.Objects->ObjSet[obj].FaceTable->FaceAmount == 
           pObj->FaceTable->FaceAmount))
        pDamPartner = &CurrentState.CurrentParams.Objects->ObjSet[obj];
      break;
    }
  if (NULL == pDamPartner)
    pDamPartner = pObj;

  //ok, go ahead;
  //1) count textures:
  xoFileHeader  Header;
  long* MatMap = new long[d3d->Materials.MaterialsAmount];
  for (mat = 0; mat < d3d->Materials.MaterialsAmount; mat++)
    MatMap[mat] = 0;
  for (face = 0; face < pObj->FaceTable->FaceAmount; face++)
  {
    mat = pObj->FaceTable->Table[face].Material;
    if (d3d->Materials.Materials[mat].MatParams.PrimTexture != -1)
    {//textured
      if (0==MatMap[mat])
        MatMap[mat] = ++Header.m_numTex; //1,2,etc.
    }//textured
  }
  LPSTR*  texMap = new LPSTR[Header.m_numTex];
  for (mat = 0; mat < d3d->Materials.MaterialsAmount; mat++)
    if (0 != MatMap[mat])
      texMap[MatMap[mat]-1] = strdup(
          d3d->Materials.Textures->GetName(
            d3d->Materials.Materials[mat].MatParams.PrimTexture));
  for (i = 0; i < Header.m_numTex; i++)
    Header.m_TexBlockSize += strlen(texMap[i])+1;

  
  Header.m_numFaces       = pObj->FaceTable->FaceAmount;
  Header.m_FacesStart     = 0x4C;
  Header.m_FacesBlockSize = sizeof(xoFace)*Header.m_numFaces;

  Header.m_numVerts       = pObj->VertTable->VertAmount;
  Header.m_VertsStart     = Header.m_FacesStart + Header.m_FacesBlockSize;
  Header.m_VertsBlockSize = sizeof(tPOINT)*Header.m_numVerts;

  Header.m_numNorms       = pObj->VertTable->VertAmount;
  Header.m_NormsStart     = Header.m_VertsStart + Header.m_VertsBlockSize;
  Header.m_NormsBlockSize = sizeof(tPOINT)*Header.m_numVerts;

  Header.m_TexStart       = Header.m_NormsStart + Header.m_NormsBlockSize;
  Header.m_fUnks[0]       = 3.0f;
  Header.m_fUnks[1]       = 0.1f;
  Header.m_fUnks[2]       = 1.0f;
  Header.m_fUnks[3]       = 0.5f;

  pFile->Write(&Header, sizeof(Header));

  xoFace* pFaces = new xoFace[Header.m_numFaces];
  tPOINT* pVerts = new tPOINT[Header.m_numVerts];
  tPOINT* pNorms = new tPOINT[Header.m_numNorms];
  for (vert = 0; vert < pObj->VertTable->VertAmount; vert++)
  {
    pVerts[vert].x =-pObj->VertTable->Table[vert].X;
    pVerts[vert].y = pObj->VertTable->Table[vert].Y;
    pVerts[vert].z = pObj->VertTable->Table[vert].Z;
    pNorms[vert].x =-pObj->VertTable->Table[vert].NormalX;
    pNorms[vert].y = pObj->VertTable->Table[vert].NormalY;
    pNorms[vert].z = pObj->VertTable->Table[vert].NormalZ;
  }
  for (face = 0; face < pObj->FaceTable->FaceAmount; face++)
  {
    pFaces[face].i1 = pFaces[face].n1 = pObj->FaceTable->Table[face].I1;
    pFaces[face].i2 = pFaces[face].n2 = pObj->FaceTable->Table[face].I2;
    pFaces[face].i3 = pFaces[face].n3 = pObj->FaceTable->Table[face].I3;
    pFaces[face].m_UVs.u1 = pObj->FaceTable->Table[face].U1;
    pFaces[face].m_UVs.u2 = pObj->FaceTable->Table[face].U2;
    pFaces[face].m_UVs.u3 = pObj->FaceTable->Table[face].U3;
    pFaces[face].m_UVs.v1 = 1.0f-pObj->FaceTable->Table[face].V1;
    pFaces[face].m_UVs.v2 = 1.0f-pObj->FaceTable->Table[face].V2;
    pFaces[face].m_UVs.v3 = 1.0f-pObj->FaceTable->Table[face].V3;
    tPOINT faceNormal = GetNormal(
	pObj->VertTable->Table[pObj->FaceTable->Table[face].I1].X,
        pObj->VertTable->Table[pObj->FaceTable->Table[face].I1].Y,
        pObj->VertTable->Table[pObj->FaceTable->Table[face].I1].Z,
	pObj->VertTable->Table[pObj->FaceTable->Table[face].I2].X,
        pObj->VertTable->Table[pObj->FaceTable->Table[face].I2].Y,
        pObj->VertTable->Table[pObj->FaceTable->Table[face].I2].Z,
	pObj->VertTable->Table[pObj->FaceTable->Table[face].I3].X,
        pObj->VertTable->Table[pObj->FaceTable->Table[face].I3].Y,
        pObj->VertTable->Table[pObj->FaceTable->Table[face].I3].Z);
    pFaces[face].fx =-faceNormal.x;
    pFaces[face].fy = faceNormal.y;
    pFaces[face].fz = faceNormal.z;
    // :FIXME: Unknwon area:
    pFaces[face].unk[0] = 1.5f;
    pFaces[face].unk[1] = 0.3f;

    pFaces[face].m_VertColor[0] = pFaces[face].m_VertColor[1] = pFaces[face].m_VertColor[2] = 0xFFFFFFFF;
    if (0==MatMap[pObj->FaceTable->Table[face].Material])
    {
      pFaces[face].m_nTexture = 0;
      // :FIXME:
      //set face's color here
      float r = d3d->Materials.Materials[mat].MatRec.diffuse.r;
      float g = d3d->Materials.Materials[mat].MatRec.diffuse.g;
      float b = d3d->Materials.Materials[mat].MatRec.diffuse.b;
      float a = d3d->Materials.Materials[mat].MatRec.diffuse.a;
      if (d3d->Materials.Materials[mat].MatParams.AlphaTreat != 1)
        a = 1.0f;
      DWORD ARGB =  (((DWORD)(a*255.0f))<<24)+
                    (((DWORD)(r*255.0f))<<16)+
                    (((DWORD)(g*255.0f))<<8)+
                    (((DWORD)(b*255.0f))<<0);
      pFaces[face].m_VertColor[0] = pFaces[face].m_VertColor[1] = pFaces[face].m_VertColor[2] = ARGB;
    }
    else
    {
      pFaces[face].m_nTexture = MatMap[pObj->FaceTable->Table[face].Material];
      pFaces[face].nFlags = XO_FACE_SOLID; //(?)
    }
    if (0==(pObj->FaceTable->Table[face].nRenderFlags & NoBlend))
      pFaces[face].nFlags |= XO_FACE_CHROME;
    if (pObj->FaceTable->Table[face].nRenderFlags & SemiTransparent)
      pFaces[face].nFlags |= XO_FACE_SEMITRANS;
  }
 
  
  pFile->WriteHuge(pFaces, sizeof(xoFace)*Header.m_numFaces);
  pFile->WriteHuge(pVerts, sizeof(tPOINT)*Header.m_numVerts);
  pFile->WriteHuge(pNorms, sizeof(tPOINT)*Header.m_numNorms);
  for (mat = 0; mat < Header.m_numTex; mat++)
    pFile->Write(texMap[mat], strlen(texMap[mat])+1);

  // put locking:
  DWORD dwLOCK[2];
  dwLOCK[0] = XO_FILE_LOCK_ID;
    dwLOCK[1] = XO_FILE_LOCK_SEED + Header.m_TexStart + (bLocked ? 0 : 1);
  pFile->Write(dwLOCK, 8);

//--------------------------------------------------------------
// Create damaged-partner.
//--------------------------------------------------------------
  CFile fileVert;
  CFile fileUV;
  if (fileVert.Open(objname+CString("_vertex.bin"), CFile::modeWrite | CFile::modeCreate) && 
      fileUV.Open(objname+CString("_uv.bin"), CFile::modeWrite | CFile::modeCreate))
  {
    xoUVs*  pUVs = new xoUVs[Header.m_numFaces];
    for (vert = 0; vert < Header.m_numVerts; vert++)
    {
      pVerts[vert].x =-pDamPartner->VertTable->Table[vert].X;
      pVerts[vert].y = pDamPartner->VertTable->Table[vert].Y;
      pVerts[vert].z = pDamPartner->VertTable->Table[vert].Z;
    }
    for (face = 0; face < Header.m_numFaces; face++)
    {
      pUVs[face].u1 = pDamPartner->FaceTable->Table[face].U1;
      pUVs[face].v1 = pDamPartner->FaceTable->Table[face].V1;
      pUVs[face].u2 = pDamPartner->FaceTable->Table[face].U2;
      pUVs[face].v2 = pDamPartner->FaceTable->Table[face].V2;
      pUVs[face].u3 = pDamPartner->FaceTable->Table[face].U3;
      pUVs[face].v3 = pDamPartner->FaceTable->Table[face].V3;
    }
    fileVert.WriteHuge(pVerts, sizeof(tPOINT)*Header.m_numVerts);
    fileUV.WriteHuge(pUVs, sizeof(xoUVs)*Header.m_numFaces);
    fileVert.Close();
    fileUV.Close();
    delete[] pUVs;
  }//there are damaged partners

  delete[] pFaces;
  delete[] pVerts;
  delete[] pNorms;
  delete[] MatMap;
  for (i = 0; i < Header.m_numTex; i++)
    free(texMap[i]);
  delete[] texMap;

  return Z3D_PLUGRESULT_REDRAW;
}




/**********************************************************************/
//        Exporter
/**********************************************************************/
DWORD CALLBACK Export(CString tofile,
                      CWnd *pwnd,
                      tObjectSet* Objects,
                      tUnDataSet* UnData,
                      CDirect3D*  d3d,
                      SYSTEMREQUESTPROC RequestProc,
                      HINSTANCE AppHIns,
                      HINSTANCE DllHIns)
{
  long iObj = -1;
  Objects->UnSelectAll();

  struct
  {
    char*         pText_ActionButton;
    sButtonType   ActionButtonType;
    sObjectsType  ListObjectsOfType;
    sObjectsType  HighlightObjectsOfType;
  }  Request;

  Request.pText_ActionButton = "Export";
  Request.ActionButtonType = Z3D_BUTTON_ACTION_SELECT;
  Request.ListObjectsOfType = Z3D_OBJTYPE_ALL;
  Request.HighlightObjectsOfType = Z3D_OBJTYPE_SELECTED;

  if (IDCANCEL == RequestProc(Z3D_REQUEST_BYNAMEBOX,
    Objects,
    "Select ONE object in the list to export:",
    (long*)&Request,
    NULL))
    return Z3D_PLUGRESULT_SELECTIONCHANGED | Z3D_PLUGRESULT_REDRAW;

  for (int i = 0; i < Objects->ObjAmount; i++)
    if (Objects->ObjSet[i].Selected() && (-1 == iObj))
      iObj = i;

  if (iObj>=0)
  {
    CFile XO;
    if (!XO.Open(tofile, CFile::modeCreate | CFile::modeWrite))
      return ShowFailMessage(
        pwnd,
        "can not open the specified file.",
        "invalid file attributes or share violation.",
        MB_ICONHAND);

    bLocked = (tofile.Right(2) != CString("XO"));
    MultipleExportV8ChallengeXO(
      &XO,
      &Objects->ObjSet[iObj],
      d3d);

    XO.Close();
  }
  return Z3D_PLUGRESULT_SELECTIONCHANGED;
}